/*
 * Copyright (c) 2025 Hochschule Darmstadt
 *
 * This software is provided exclusively for the practical part of the
 * course 'Embedded Systems' at 'Darmstadt University of Applied Sciences
 * (Hochschule Darmstadt, h_da)'.
 *
 * Any use, distribution, or modification outside this context is prohibited
 * without explicit permission.
 *
 * AUTHORS: David Heiß, Manfred Pester, Jens-Peter Akelbein
 * FILE: matrix.c
 * CONTENTS: implementation for all functions driving I2C LED matrix
 */

#include "matrix.h"

#include <cm3.h>
#include <sam.h>
#include <state.h>
#include <stdbool.h>

static unsigned char buffer[] = {[0 ... 16] = 0};

static bool matrix_ready()
{
    // TODO
    return false;
}

static bool matrix_write(const unsigned char *buf, unsigned int n)
{
    // TODO

    return true;
}

static bool matrix_distance(int dist)
{
    if (!matrix_ready())
        return false;

    /*
     * Beispiel
     * Nur jeder zweiter Eintrag wird auf der Matrix angezeigt.
     * Der Kontroller ist für zwei Matrizen ausgelegt.
     */
    for (unsigned int i = 0; i < 8; i++)
    {
        buffer[1 + i * 2] |= 1 << i;
    }

    // TODO

    matrix_write(buffer, sizeof(buffer));
    return true;
}

void matrix_init(void)
{
    // TODO

    unsigned char init_sequence[] = {
        0x21, // internal system clock enable
        0xA0, // row output pin set
        0xE0, // dimming set
        0x81, // blinking set
    };

    for (unsigned int i = 0; i < sizeof(init_sequence); i++)
        while (!matrix_write(init_sequence + i, 1));

    while (!matrix_write(buffer, sizeof(buffer)));
}

void matrix_loop(void)
{
    matrix_distance(value.sonic.distance - value.goal);
}
