/*
 * Copyright (c) 2025 Hochschule Darmstadt
 *
 * This software is provided exclusively for the practical part of the
 * course 'Embedded Systems' at 'Darmstadt University of Applied Sciences
 * (Hochschule Darmstadt, h_da)'.
 *
 * Any use, distribution, or modification outside this context is prohibited
 * without explicit permission.
 *
 * AUTHORS: David Heiß, Manfred Pester, Jens-Peter Akelbein
 * FILE: sonic.h
 * CONTENTS: declaration of sonic driver using ultrasonic sensor HC-SR04
 */

#include <sonic.h>

#include <constants.h>
#include <sam.h>
#include <state.h>

// Measurements restarted with this frequency of trigger pulse
#define TRIGGER_FREQUENCY 10

// Sonic speed is about 343 m/s at 20 degrees Celsius
#define SONIC_SPEED 343

static inline void trigger_enable(void)
{
    PIOC_PDR = PIOC_PDR_P29;
}

static inline void trigger_disable(void)
{
    PIOC_PER = PIOC_PER_P29;
}

static void trigger_init(void)
{
    // TODO
}

static void echo_init(void)
{
    // TODO
}

void sonic_init(void)
{
    trigger_init();
    echo_init();
}

static void trigger_loop(void)
{
    if (state.sonic == SONIC_STATE_OFF)
        trigger_disable();
    else
        trigger_enable();
}

static void echo_loop(void)
{
   // TODO
}

void sonic_loop(void)
{
    trigger_loop();
    echo_loop();
}