/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.iaccess.launch;

import com.ibm.iaccess.launch.AcsJarContentsCache;
import com.ibm.iaccess.launch.AcsLaunchLocator;
import com.ibm.iaccess.launch.AcsLaunchPad;
import com.ibm.iaccess.launch.AcsProperties;
import com.ibm.iaccess.launch.AcsStartupUtil;
import com.ibm.iaccess.launch.CopyrightLaunch;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.net.URL;
import java.util.LinkedList;
import java.util.List;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;

@CopyrightLaunch(value="Licensed Materials - Property of IBM\n5733-XJ1\n(C) Copyright IBM Corp. 2011, 2017. All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.\n")
public class AcsLookasideJarsMgr {
    private List<URL> m_lookasideJars = null;
    private final boolean m_isLookasideReady;
    private final File m_dir;
    private final File m_lookasideDirFile = new File(System.getProperty("java.io.tmpdir") + File.separator + "acs.jar_cache" + String.format("%x", new String(AcsJarContentsCache.getThisProcessUniqueSeed()).hashCode()) + String.format("%x", System.getProperty("user.name").hashCode()));
    public static final String JAR_CACHE_DIR_PREFIX = "acs.jar_cache";

    public AcsLookasideJarsMgr() {
        boolean bl = false;
        File file = null;
        try (BufferedReader bufferedReader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(this.m_lookasideDirFile), "UTF-8"));){
            String string = bufferedReader.readLine();
            File file2 = new File(string);
            if (file2.isDirectory()) {
                bl = true;
                file = file2;
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            AcsStartupUtil.addDelayedLog(fileNotFoundException.toString());
        }
        catch (Exception exception) {
            AcsStartupUtil.addDelayedLog(exception);
        }
        if (null == file && AcsLookasideJarsMgr.isUsed()) {
            try {
                file = AcsLookasideJarsMgr.getNewJarLookasideDir();
            }
            catch (IOException iOException) {
                throw new RuntimeException(iOException);
            }
        }
        this.m_dir = file;
        this.m_isLookasideReady = bl;
    }

    public synchronized void load(List<URL> list) throws IOException {
        Object object;
        if (null != this.m_lookasideJars) {
            return;
        }
        this.m_lookasideJars = new LinkedList<URL>();
        boolean bl = !this.m_isLookasideReady;
        int n = 1;
        if (bl) {
            for (URL serializable : list) {
                if (AcsLaunchPad.isJarFileHiddenFromView(serializable.toString())) continue;
                File throwable = new File(this.m_dir.getAbsolutePath() + File.separator + n++ + ".dat").getAbsoluteFile();
                AcsStartupUtil.addDelayedLog("Creating lookaside data file: " + throwable + "....");
                throwable.getParentFile().mkdirs();
                try (InputStream inputStream = serializable.openConnection().getInputStream();
                     BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(throwable), 524288);){
                    int n2;
                    byte[] byArray = new byte[65536];
                    while ((n2 = inputStream.read(byArray)) != -1) {
                        ((OutputStream)bufferedOutputStream).write(byArray, 0, n2);
                    }
                }
                AcsStartupUtil.addDelayedLog("Done creating lookaside data file: " + throwable);
                this.m_lookasideJars.add(throwable.toURI().toURL());
            }
        } else {
            while (((File)(object = new File(this.m_dir.getAbsolutePath() + File.separator + n++ + ".dat").getAbsoluteFile())).exists()) {
                this.m_lookasideJars.add(((File)object).toURI().toURL());
            }
        }
        if (bl) {
            try {
                object = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(this.m_lookasideDirFile), "UTF-8"));
                Throwable throwable = null;
                try {
                    ((Writer)object).write(this.m_dir.getAbsolutePath());
                }
                catch (Throwable throwable2) {
                    Throwable throwable3 = throwable2;
                    throw throwable2;
                }
                finally {
                    if (object != null) {
                        if (throwable != null) {
                            try {
                                ((BufferedWriter)object).close();
                            }
                            catch (Throwable throwable4) {
                                throwable.addSuppressed(throwable4);
                            }
                        } else {
                            ((BufferedWriter)object).close();
                        }
                    }
                }
            }
            catch (Exception exception) {
                AcsStartupUtil.addDelayedLog(exception);
            }
        }
    }

    public List<URL> getLookasideJars() {
        return this.m_lookasideJars;
    }

    private static File getNewJarLookasideDir() throws IOException {
        File file = File.createTempFile(JAR_CACHE_DIR_PREFIX, ".dir");
        file.delete();
        file.mkdirs();
        if (file.isDirectory() && file.exists()) {
            return file;
        }
        throw new IOException("Unable to get Jar lookaside directory");
    }

    public static final boolean isUsed() {
        return AcsProperties.getProperties().isLocalJarCaching() && AcsLaunchLocator.getLocator().isInsideJarOrZip();
    }

    public boolean isPrimeNeeded() {
        return !this.m_isLookasideReady && AcsLookasideJarsMgr.isUsed() && null == this.m_lookasideJars;
    }

    public void getPlugins(List<String> list) {
        if (null == this.m_lookasideJars) {
            throw new RuntimeException();
        }
        try {
            for (URL uRL : this.m_lookasideJars) {
                JarFile jarFile = new JarFile(new File(uRL.toURI()));
                Throwable throwable = null;
                try {
                    String string;
                    Attributes attributes;
                    Manifest manifest = jarFile.getManifest();
                    if (null == manifest || null == (attributes = manifest.getMainAttributes()) || null == (string = attributes.getValue("Acs-Plugins"))) continue;
                    for (String string2 : string.split("\\s+")) {
                        list.add(string2);
                    }
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (jarFile == null) continue;
                    if (throwable != null) {
                        try {
                            jarFile.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    jarFile.close();
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new RuntimeException(exception);
        }
    }
}

